/**
 * StatusPage Widget Gutenberg Block
 *
 * @package StatusPageWidget
 */

import { registerBlockType } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';
import Edit from './edit';
import './editor.scss';

/**
 * Block icon
 */
const icon = (
    <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <circle cx="12" cy="12" r="10" fill="#16c172" />
        <path
            d="M8 12l2.5 2.5L16 9"
            stroke="#fff"
            strokeWidth="2"
            strokeLinecap="round"
            strokeLinejoin="round"
        />
    </svg>
);

/**
 * Register the block
 */
registerBlockType('status-page-widget/status-widget', {
    title: __('StatusPage Widget', 'status-page-widget'),
    description: __('Display a real-time status widget from StatusPage.me.', 'status-page-widget'),
    category: 'widgets',
    icon,
    keywords: [
        __('status', 'status-page-widget'),
        __('uptime', 'status-page-widget'),
        __('monitoring', 'status-page-widget'),
    ],
    edit: Edit,
    save: () => null, // Dynamic block - rendered server-side
});
